<?php
/**
 * Archivo de configuración de ejemplo
 *
 * Copie este archivo como `config.php` y modifique los valores según su entorno.
 * El instalador generará automáticamente este archivo durante el proceso de instalación.
 */

return [
    // Configuración de la base de datos del sistema PDV
    'pdv' => [
        'host' => 'localhost',
        'database' => 'pdv',
        'username' => 'root',
        'password' => '',
        'charset'  => 'utf8mb4',
    ],

    // Configuración de la base de datos de PrestaShop
    'prestashop' => [
        'host' => 'localhost',
        'database' => 'prestashop',
        'username' => 'root',
        'password' => '',
        // Prefijo de tablas de PrestaShop (por defecto `ps_`)
        'prefix' => 'ps_',
        'charset' => 'utf8mb4',
    ],

    // Configuraciones generales de la aplicación
    'app' => [
        // Clave secreta para proteger sesiones y tokens. Cambie esto a un valor aleatorio.
        'secret_key' => 'cambie-esta-clave',
        // URL base del sistema (ej. https://midominio.com/pos)
        'base_url'   => '',
    ],
];