<?php
require_once __DIR__ . '/includes/functions.php';

/**
 * Renderiza la cabecera y la barra de navegación.
 *
 * @param string $title
 * @param string $active Nombre del menú activo
 */
function renderHeader(string $title = '', string $active = ''): void
{
    $user = currentUser();
    $username = $user['username'] ?? '';
    ?>
    <!DOCTYPE html>
    <html lang="es">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title><?php echo escape($title); ?> - PDV</title>
        <!-- Bootstrap CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-2ZY5sxzobS//s3m4W9Pi1s2ynG1iXGk4MReeQ0bGAP7zRvH+6zCuN6E6a2hZIlK" crossorigin="anonymous">
        <style>
            body {
                min-height: 100vh;
                display: flex;
                flex-direction: column;
            }
            .sidebar {
                width: 220px;
                position: fixed;
                top: 0;
                bottom: 0;
                left: 0;
                padding: 60px 0 0; /* espacio para la navbar */
                background-color: #343a40;
                color: #fff;
            }
            .sidebar a {
                color: #ddd;
                display: block;
                padding: 10px 20px;
                text-decoration: none;
            }
            .sidebar a.active, .sidebar a:hover {
                background-color: #495057;
                color: #fff;
            }
            .content {
                margin-left: 220px;
                padding: 70px 20px 20px;
            }
        </style>
    </head>
    <body>
    <!-- Topbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo baseUrl('index.php'); ?>">PDV</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <span class="nav-link text-light">Bienvenido, <?php echo escape($username); ?></span>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo baseUrl('logout.php'); ?>">Cerrar sesión</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <!-- Sidebar -->
    <div class="sidebar">
        <?php if (hasPermission('dashboard', 'view')): ?>
            <a href="<?php echo baseUrl('dashboard.php'); ?>"<?php echo ($active === 'dashboard') ? ' class="active"' : ''; ?>>Inicio</a>
        <?php endif; ?>
        <?php if (hasPermission('users', 'view')): ?>
            <a href="<?php echo baseUrl('users.php'); ?>"<?php echo ($active === 'users') ? ' class="active"' : ''; ?>>Usuarios</a>
        <?php endif; ?>
        <?php if (hasPermission('roles', 'view')): ?>
            <a href="<?php echo baseUrl('roles.php'); ?>"<?php echo ($active === 'roles') ? ' class="active"' : ''; ?>>Roles</a>
        <?php endif; ?>
        <?php if (hasPermission('boxes', 'view')): ?>
            <a href="<?php echo baseUrl('boxes.php'); ?>"<?php echo ($active === 'boxes') ? ' class="active"' : ''; ?>>Cajas</a>
        <?php endif; ?>
        <?php if (hasPermission('settings', 'view')): ?>
            <a href="<?php echo baseUrl('settings.php'); ?>"<?php echo ($active === 'settings') ? ' class="active"' : ''; ?>>Configuraciones</a>
        <?php endif; ?>
        <?php if (hasPermission('pos', 'view')): ?>
            <a href="<?php echo baseUrl('pos.php'); ?>"<?php echo ($active === 'pos') ? ' class="active"' : ''; ?>>Punto de Venta</a>
        <?php endif; ?>
        <?php if (hasPermission('stats', 'view')): ?>
            <a href="<?php echo baseUrl('stats.php'); ?>"<?php echo ($active === 'stats') ? ' class="active"' : ''; ?>>Estadísticas</a>
        <?php endif; ?>
    </div>
    <!-- Contenido principal -->
    <div class="content">
    <?php
}

/**
 * Renderiza el pie de página y scripts necesarios.
 */
function renderFooter(): void
{
    ?>
    </div> <!-- /.content -->
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-qo1NK9vdN2AyJEaCmxEtdlJ6dNVY4s9dL7LTrO2TV4QZk2aIy08eRUKqT1syeZye" crossorigin="anonymous"></script>
    </body>
    </html>
    <?php
}