<?php
require_once __DIR__ . '/includes/functions.php';

// Si no hay configuración, ir al instalador
if (!loadConfig()) {
    header('Location: install/');
    exit;
}

// Si ya está logueado, ir a index
if (isLoggedIn()) {
    redirect('index.php');
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    if ($username === '' || $password === '') {
        $error = 'Todos los campos son obligatorios.';
    } else {
        $pdo = getPDO();
        if ($pdo) {
            $stmt = $pdo->prepare('SELECT * FROM users WHERE username = :u LIMIT 1');
            $stmt->execute([':u' => $username]);
            $user = $stmt->fetch();
            if ($user && password_verify($password, $user['password'])) {
                $_SESSION['user_id'] = $user['id'];
                redirect('index.php');
            } else {
                $error = 'Usuario o contraseña incorrectos.';
            }
        } else {
            $error = 'No se pudo conectar a la base de datos.';
        }
    }
}

?><!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Iniciar sesión - PDV</title>
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-2ZY5sxzobS//s3m4W9Pi1s2ynG1iXGk4MReeQ0bGAP7zRvH+6zCuN6E6a2hZIlK" crossorigin="anonymous">
    <!-- Iconos Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-p+bsAoI8zwlFuvUihh1f5RduCMsZ/HXXIQK5vCk1vZ1tcHTTX3e8DqRLVQjaxctq6nxsVXniPjWh9sC/WZE/lQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- Estilos personalizados (parámetro de versión para evitar caché) -->
    <link rel="stylesheet" href="<?php echo baseUrl('assets/css/style.css?v=1.5'); ?>">
    <style>
        /* Ajustes específicos para el login */
        body {
            background-color: var(--bg-color);
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
        }
        .login-card {
            background-color: var(--card-bg);
            border: none;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            padding: 30px;
            width: 100%;
            max-width: 420px;
        }
    </style>
</head>
<body>
<div class="login-card">
    <h3 class="mb-4 text-center"><i class="fas fa-cash-register me-2"></i>Acceder al PDV</h3>
    <?php if ($error): ?>
        <div class="alert alert-danger" role="alert">
            <?php echo escape($error); ?>
        </div>
    <?php endif; ?>
    <form method="post" action="">
        <div class="mb-3">
            <label for="username" class="form-label">Usuario</label>
            <input type="text" class="form-control" id="username" name="username" required autofocus>
        </div>
        <div class="mb-3">
            <label for="password" class="form-label">Contraseña</label>
            <input type="password" class="form-control" id="password" name="password" required>
        </div>
        <button type="submit" class="btn btn-primary w-100">Iniciar sesión</button>
    </form>
</div>
<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-qo1NK9vdN2AyJEaCmxEtdlJ6dNVY4s9dL7LTrO2TV4QZk2aIy08eRUKqT1syeZye" crossorigin="anonymous"></script>
</body>
</html>